/*
	Stargate Lib for GarrysMod10
	Copyright (C) 2007  aVoN

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
--################# Header ###################
StarGate.HTTP = {
	BUGS = "http://mantis.39051.vs.webtropia.com",
	INTERNET = "http://stargatepack.googlecode.com/svn/help/HASINTERNET.TXT",
	VERSION = "http://stargatepack.googlecode.com/svn/help/VERSION.TXT",
	GMOD = "http://stargatepack.googlecode.com/svn/help/GMOD.TXT",
};

--################# CODE ###################

--#########################################
--						Internet communication
--#########################################
include("includes/modules/http.lua");
-- Do we have internet?
StarGate.HasInternet = false;
-- Some percentage crashes by this online help check. Now we check this if they crash once during this check, this check will be disabled permanently for them
local PlayerCrashed = util.tobool(file.Read("stargate.http.crash.txt"));
if(PlayerCrashed) then
	StarGate.HasInternet = true; -- Even if they crashed by this test here, enable online help.
else
	file.Write("stargate.http.crash.txt","1");
	http.Get(StarGate.HTTP.INTERNET,"",
		function(html,size)
			if(html == "1") then
				MsgN("Stargate: Client has Internet. Enabled Online-Help"); -- Formally for Debug but: Hey, how can it be wrong?
				StarGate.HasInternet = true;
			end
		end
	);
	-- Do we have the latest version of SG installed?
	http.Get(StarGate.HTTP.VERSION,"",
		function(html,size)
			local version = tonumber(html);
			if(version) then
				StarGate.LATEST_VERSION = version;
			end
		end
	);
	file.Delete("stargate.http.crash.txt");
end

--#########################################
--						Config Part
--#########################################

--################# Getting synced data from the server @aVoN
function StarGate.CFG.GetSYNC(data)
	StarGate.Installed = true; -- Just to be sure, when the real call got lost
	local name = data:ReadString();
	StarGate.CFG[name] = {};
	for i=1,data:ReadChar() do
		local k = data:ReadString();
		local t = data:ReadChar(); -- What type are we?
		if(t == 0) then
			StarGate.CFG[name][k] = data:ReadBool();
		elseif(t == 1) then
			StarGate.CFG[name][k] = data:ReadString();
		elseif(t == 2) then
			StarGate.CFG[name][k] = data:ReadFloat();
		elseif(t == 3) then
			StarGate.CFG[name][k] = data:ReadChar();
		elseif(t == 4) then
			StarGate.CFG[name][k] = data:ReadShort();
		elseif(t == 5) then
			StarGate.CFG[name][k] = data:ReadLong();
		end
	end
end
usermessage.Hook("StarGate_CFG",StarGate.CFG.GetSYNC);

--################# Let's hope, the umsg isn't lost during connection or they won't see the tab @aVoN
usermessage.Hook("StarGate_IsOnServer",
	function()
		StarGate.Installed = true;
	end
);

--################# Adds LifeSupport,ResourceDistribution and WireSupport to an entity when getting called - HAS TO BE CALLED BEFORE ANY OTHERTHING IS DONE IN A SENT (like includes) @aVoN
-- My suggestion is to put this on the really top of the shared.lua
function StarGate.LifeSupportAndWire(ENT)
	-- Currently a dummy, but maybe I need this sometime later?
end

--#########################################
--						Material Helpers
--#########################################

--################# Creates a new Material according to a given VMT String @aVoN
-- This is necessary, because sometimes you need to edit a material in an effect which results into conflicts with other scripts using that material too
function StarGate.MaterialFromVMT(name,VMT)
	if(type(VMT) ~= "string" or type(name) ~= "string") then return Material("") end; -- Return a dummy Material
	local t = util.KeyValuesToTable("\"material\"{"..VMT.."}");
	for shader,params in pairs(t) do
		return CreateMaterial(name,shader,params);
	end
end

--################# Creates a copy of an existing Material and returns it @aVoN
function StarGate.MaterialCopy(name,filename)
	if(type(filename) ~= "string" or type(name) ~= "string") then return Material("") end; -- Return a dummy Material
	filename = "../materials/"..filename:Trim():gsub(".vmt$","")..".vmt";
	return StarGate.MaterialFromVMT(name,file.Read(filename));
end
