/*
	Stargate SENT for GarrysMod10
	Copyright (C) 2007  aVoN

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
-- FIXME: Todo - Rewrite this using "ANIM" like in "stargate_iris" sent.
ENT.Sequence = {};

--#################  Milkyway gates - dialling sequence @aVoN
-- ATTENTION: The dialling time takes exactly 7 seconds with my gates (dialled in fast mode). When you code your own gates, make them take 7 seconds too!
-- You can check a dialling sequence's length with adding "print_r(delay)" to end of the stargate_base's ENT:RunAction() function
function ENT.Sequence:Dial(inbound,fast,fail)
	local action = self:New();
	--################# INBOUND AND DHD (fast) DIAL
	if(inbound or fast) then
		local add = 29.5;
		if(fast) then add = 0 end;
		local rnd = {}; -- Increase randomness (makes it less artificial)
		for i=1,5 do
			math.randomseed(os.clock()+i);
			rnd[i] = math.random(30,100)/100;
		end
		rnd[6] = 1;
		local delta = (4.8 - (rnd[1]+rnd[2]+rnd[3]+rnd[4]+rnd[5]+rnd[6]))/6; -- Neede, so the eventhorizons get opened in the same time
		action:Add({f=self.SetStatus,v={self,false,true,true},d=add}); -- The first true tells, "we are in use", but the last tells wire NOT to indicate us as "Active". Otherwise, on a slow dial-in, a gate becomes "Wire-Active" even if it's not currently dialling
		action:Add({f=self.SetStatus,v={self,false,true},d=0.1}); -- The 0.1 seconds prevents a bug where an incoming call overrides an outgoing (slow dial) and the first chevrons stays disabled (so we need definitely a shot delay!) - This additional 0.1 we take here has been removed on the chevron7-lock delay in the for loop below
		if(inbound) then
			-- This adds some more delay between eachchevron.
			-- This corrects the 0.9 seconds which are missing from not spinning the ring (below) and the missing 1 second from Chevron7 till the event horizon openes (1.3 seconds vs 0.3)
			delta = delta + 1.9/6;
		else
			action:Add({f=self.ActivateRing,v={self,true},d=0.9}); -- Start spinning
		end
		--Chevron 1-7
		for i=1,7 do
			-- Chevron lights
			if(i == 7 and fail) then
				action:Add({f=self.SetWire,v={self,"Chevron",-7},d=0}); -- Wire
			else
				action:Add({f=self.ActivateChevron,v={self,i,true},d=0});
				action:Add({f=self.DHDSetChevron,v={self,i,0.05},d=0});
				action:Add({f=self.SetWire,v={self,"Chevron",i},d=0}); -- Wire
				if(i == 7) then
					if(inbound) then
						action:Add({f=self.ChevronSound,v={self,i,fast,inbound},d=0.2});
					else
						action:Add({f=self.ActivateRing,v={self,false},d=0}); -- Stop Ring
						action:Add({f=self.Chevron7Animation,v={self,true},d=0}); -- Animate chevron 7
						action:Add({f=self.ChevronSound,v={self,i,fast,inbound},d=1.2}); -- Chevron Locked
					end
				else
					action:Add({f=self.ChevronSound,v={self,i,fast,inbound},d=rnd[i]+delta}); -- Chevron Locked
				end
			end
		end
	else
		--################# OUTBOUND DIALLING (slow)
		local rnd = {}; -- Increases randomness
		for i=1,7 do
			math.randomseed(os.clock()+i);
			rnd[i] = math.random(300,400)/100;
		end
		local delta = (20-(rnd[1]+rnd[2]+rnd[3]+rnd[4]+rnd[5]+rnd[6]+rnd[7]))/7; -- Add delta values according to the random dialling speed to fit 7 seconds
		action:Add({f=self.SetStatus,v={self,false,1},d=0}); -- The 1 means, it's dailling slowly and "can be dialled in" (About Dialling out) - It's special for SG1 Gate and is handled in ENT:ActivateStargate()
		-- Chevron 1-7
		for i=1,7 do
			-- Spinning ring
			action:Add({f=self.ActivateRing,v={self,true},d=rnd[i]+delta}); -- Roll the ring
			action:Add({f=self.ActivateRing,v={self,false},d=0}); -- Stop the ring
			action:Add({f=self.DHDSetChevron,v={self,i},d=0});
			-- Chevron lights
			if(i == 7) then
				if(fail) then
					action:Add({f=self.SetWire,v={self,"Chevron",-7},d=0}); -- Wire
				else
					action:Add({f=self.ActivateChevron,v={self,i,true},d=0}); -- Chevron7 lights up
					action:Add({f=self.Chevron7Animation,v={self,true},d=0}); -- Animate chevron 7
					action:Add({f=self.SetWire,v={self,"Chevron",i},d=0}); -- Wire
					action:Add({f=self.ChevronSound,v={self,i},d=1.5}); -- Chevron Locked
				end
			else
				action:Add({f=self.ChevronSound,v={self,i},d=0.4}); -- Chevron Locked
				action:Add({f=self.Chevron7Animation,v={self},d=0}); -- Animate chevron 7
				action:Add({f=self.ActivateChevron,v={self,7,true},d=1.3}); -- Chevron7 lights up
				action:Add({f=self.SetWire,v={self,"Chevron",i},d=0}); -- Wire
				action:Add({f=self.ActivateChevron,v={self,i,true},d=0.4}); -- The new chevron is getting locked in
				action:Add({f=self.ActivateChevron,v={self,7,false},d=0.4}); -- Chevron 7 goes off
			end
		end
	end
	if(not fail) then
		action:Add({f=self.DHDSetChevron,v={self,8},d=0}); -- Activate near DHDs
	end
	return action;
end
