/*
	Staff Weapon for GarrysMod10
	Copyright (C) 2007  aVoN

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

--################# HEADER #################
AddCSLuaFile("cl_init.lua");
AddCSLuaFile("shared.lua");
include("shared.lua");
ENT.Untouchable = true;
--################# SENT CODE ###############

--################### Init @aVoN
function ENT:Initialize()
	self.BaseClass.Initialize(self);
	self.ExplosiveRadius = StarGate.CFG:Get("staff_stationary","radius",300);
	self.ExplosiveDamage = StarGate.CFG:Get("staff_stationary","damage",200);
	self.MaxPasses = StarGate.CFG:Get("staff_stationary","maxpasses",300);
	self.Effects.Explode = "staff_explosion";
	self.Created = CurTime();
	if(self.Phys and self.Phys:IsValid()) then
		self.Phys:SetMass(60);
	end
end

--################### Touch - When to explode? @aVoN
function ENT:Touch(e)
	if(e and e.IgnoreStaff) then return end;
	-- ######################## Neccessary, or fast vehicles will explode, because they collide with the projectile
	if(StarGate.CanTouch({BaseVelocity=self.CannonVelocity,Velocity=self.Entity:GetVelocity(),Time=self.Created})) then
		-- This checks, if the thing we hit REALLY is there, where we hit it (This is for a workaround or FUCKIN BLASTS explodes because of hitting out ship - WTF)
		if(ValidEntity(e)) then
			local pos = self.Entity:GetPos();
			if((e:NearestPoint(pos)-pos):Length() > 100) then return end;
		end
		self.BaseClass.Touch(self,e);
	end
end

--################### Think @aVoN
function ENT:Think()
	-- Distance Explosion
	self.BaseClass.Think(self);
	if(self.Distance and self.Distance > 0 and self.StartPos) then
		if((self.Entity:GetPos()-self.StartPos):Length() >= self.Distance) then
			self:Touch();
			return;
		end
		self.Entity:NextThink(CurTime()+0.025); -- Let it think 8 times faster than normal, to make it really explode at the correct distance - This can be done with a timer a bit easier, and faster. My current speed calculation for a shot are 3,333 units/secong as speed-limit by source engine. And this shot is using it. But what happens, when someone figures out, how to change the speedlimit? "HUH!"
		return true;
	end
end
