-- Small library loader! Therefore no GPL Header (but it's GPLed)
StarGate = StarGate or {};
include("stargate/VERSION.lua");
-- Only loads serverside files on server,clientside files on client, shared on both and vgui on client
local function ValidToInclude(state)
	return (state == "server" and SERVER) or ((state == "client" or state == "vgui") and CLIENT) or state == "shared";
end
--################# Loads the libraries @aVoN
function StarGate.Load()
	MsgN("=======================================================");
	MsgN("StarGate Pack: Initializing");
	MsgN("Version: "..StarGate.VERSION.."\n");
	for _,state in pairs({"shared","server","client","vgui"}) do
		-- Init always comes at first!
		if(ValidToInclude(state) and #file.FindInLua("stargate/"..state.."/init.lua") == 1) then
			MsgN("Loading: stargate/"..state.."/init.lua");
			include("stargate/"..state.."/init.lua");
		end
		for _,v in pairs(file.FindInLua("stargate/"..state.."/*.lua")) do
			if(SERVER and state ~= "server") then
				AddCSLuaFile("stargate/"..state.."/"..v); -- Add clientside files
			end
			if(ValidToInclude(state) and v ~= "init.lua") then
				MsgN("Loading: stargate/"..state.."/"..v);
				include("stargate/"..state.."/"..v);
			end
		end
	end
	if(SERVER) then
		AddCSLuaFile("autorun/stargate.lua"); -- Ourself of course!
		AddCSLuaFile("stargate/VERSION.lua"); -- Version
		AddCSLuaFile("weapons/gmod_tool/stargate_base_tool.lua"); -- Special GMOD Basetool
	end
	MsgN("=======================================================");
end
StarGate.Load();

--################# For the concommand @aVoN
function StarGate.CallReload(p,override) -- Override is called in stargate_base/init.lua if someone calls lua_reloadents
	if(override or (not ValidEntity(p) or SinglePlayer() or p:IsAdmin())) then
		StarGate.Load();
		for _,v in pairs(player.GetAll()) do
			v:SendLua("StarGate.Load()");
		end
	else
		p:SendLua("StarGate.Load()");
	end
end

if SERVER then
	concommand.Add("stargate_reload",StarGate.CallReload);
end
