AddCSLuaFile( "cl_init.lua" )
AddCSLuaFile( "shared.lua" )
include('shared.lua')

function ENT:Initialize()
	self.Entity:SetModel("models/zup/sg_rings/ring.mdl")
	self.Entity:PhysicsInit( SOLID_VPHYSICS )
	self.Entity:SetMoveType(MOVETYPE_VPHYSICS)
	self.Entity:SetSolid(SOLID_VPHYSICS)
	
	self.Phys=self.Entity:GetPhysicsObject()
	self.Phys:EnableCollisions(false)
	self.Phys:Wake()
	self.Phys:EnableMotion(true)
	
	self.Parent=self.Entity:GetParent()
	self.Entity:SetParent(nil)
	
	self.ReachedPos=true
	self.DesiredPos=self.Entity:GetPos()
	self.Return=true
	self.Ang=self.Entity:GetAngles()
	self.Entity:StartMotionController()

	self.Entity:SetTrigger(true)
end

function ENT:PhysicsSimulate( phys, deltatime )
		phys:Wake()
		local pr={}
			pr.secondstoarrive	= 1
			local pos=self.Parent:LocalToWorld(self.DesiredPos)
			pr.pos			= pos
				if self.Return then
					pr.pos 	= self.Parent:GetPos()
				end
			pr.maxangular		= 5000
			pr.maxangulardamp	= 10000
			pr.maxspeed			= 10000
			pr.maxspeeddamp		= 100000
			pr.dampfactor		= 0.2
			if not self.Return and self.ReachedPos then
				pr.secondstoarrive	= 0.01
				pr.dampfactor		= 1
			end
			pr.teleportdistance	= 10000
			pr.angle			= self.Ang
			pr.deltatime		= deltatime
		phys:ComputeShadowControl(pr)
end

function ENT:GotoPos(len)
	if not self or not self.Entity or not self.Entity:IsValid() then return end
	self.Return=false
	self.ReachedPos=false
	self.DesiredPos=len
end

function ENT:StartTouch(ent)
	if self.ReachedPos then return end
	if ent:GetClass()=="prop_physics" or ent:IsPlayer() then
		ent:TakeDamage(1000, self.Entity)
	end
end

function ENT:ReturnPos()
	if not self or not self.Entity or not self.Entity:IsValid() then return end
	self.Return=true
end

function ENT:Think()
	if not self.ReachedPos then
		local pos=self.Parent:LocalToWorld(self.DesiredPos)
		if self.Entity:GetPos():Distance(pos)<10 then
			self.ReachedPos=true
			self.Parent:ReportReachedPos(self.Entity)
		end
	end
end
