/*
	Stargate for GarrysMod10
	Copyright (C) 2007  aVoN

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

-- This HTMl Based Frame will show HTML HELP

PANEL = {};
PANEL.Data = {
	URL="http://stargatepack.googlecode.com/svn/help/", -- Base URL
	Width=ScrW()-100,
	Heigth=ScrH()-100,
}

--################# Inits @aVoN
function PANEL:Init()
	self:SetMinimumSize(100,40);
	self:SetSize(self.Data.Width,self.Data.Heigth);
	self:SetKeyBoardInputEnabled(true);
	self:SetMouseInputEnabled(true);
	if(not self.Data.HasBeenOpened) then
		self:Center();
		self.Data.HasBeenOpened =true;
	else
		self:SetPos(self.Data.X,self.Data.Y);
	end
	self.VGUI = {
		HTML = vgui.Create("HTML",self),
		TitleLabel = vgui.Create("DLabel",self),
	};
	self.VGUI.TitleLabel:SetPos(30,7);
	self.VGUI.TitleLabel:SetText("Help");
	self.VGUI.TitleLabel:SetWide(300);
	self.VGUI.HTML:SetPos(10,30);
end

--################# Set the required URL @aVoN
function PANEL:SetURL(url)
	self.VGUI.HTML:OpenURL(url);
end

--################# Topic! @aVoN
function PANEL:SetText(text)
	self.VGUI.TitleLabel:SetText((text or ""):gsub("#",""));
end

--################# HELP Category @aVoN
function PANEL:SetHelp(help)
	self:SetURL(self.Data.URL..help..".html");
end

--################# Resize the HTML GUI in this frame to the borders @aVoN
function PANEL:PerformLayout()
	local w,h = self:GetSize();
	self.VGUI.HTML:SetSize(w-20,h-40);
	self.Data.Width,self.Data.Heigth = w,h;
end

--################# Think @aVoN
function PANEL:Think()
	self.Data.X,self.Data.Y = self:GetPos();
end

--################# Paint @aVoN
function PANEL:Paint()
	draw.RoundedBox(10,0,0,self:GetWide(),self:GetTall(),Color(16,16,16,160));
	return true;
end

vgui.Register("SHTMLHelp",PANEL,"Frame");