-- print_r function by aVoN - use it anywhere you want - Dumps data from all datatypes into console
local function do_print_r(arg,n)
	n = n or 0; -- Nil?
	local add_spaces = "";
	for k=1,n do
		add_spaces = add_spaces.."  ";
	end
	local arg_type = type(arg);
	if(arg_type == "table") then
		Msg("(table) "..tostring(arg):gsub("table: ","").." { \n");
		for k,v in pairs(arg) do
			if(v ~= arg) then
				Msg("  "..add_spaces.."("..type(k)..") "..tostring(k).." => ");
				do_print_r(rawget(arg,k),n+1);
			else
				Msg("  "..add_spaces.."("..type(k)..") "..tostring(k).." => [RECURSIVE TABLE: "..tostring(v).."]\n");
			end
		end
		Msg(add_spaces.."}\n");
	elseif(arg_type == "function") then
		Msg("(function) "..tostring(arg):gsub("function: ","").."\n");
	else
		Msg("("..arg_type..") "..tostring(arg).."\n");
	end
end

function print_r(...)
	-- Single data input
	if(arg.n == 1) then
		do_print_r(arg[1]);
	else
		for k=1,arg.n do
			do_print_r(arg[k]);
		end
	end
end
