/*
	Stargate Lib for GarrysMod10
	Copyright (C) 2007  aVoN

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
--################# Loads the menues #################

-- Defines
CreateClientConVar("cl_stargate_visuals",1,true,false); -- Global - Turns on or off all visuals which may suck FPS. Turning this to off will turn of all. If it's on, the one below will be used
CreateClientConVar("cl_stargate_dynlights",1,true,false);
CreateClientConVar("cl_stargate_ripple",1,true,false);
CreateClientConVar("cl_zat_dynlights",1,true,false);
CreateClientConVar("cl_zat_hiteffect",1,true,false);
CreateClientConVar("cl_zat_dissolveeffect",1,true,false);
CreateClientConVar("cl_staff_dynlights",0,true,false);
CreateClientConVar("cl_staff_dynlights_flight",0,true,false);
CreateClientConVar("cl_staff_scorch",1,true,false);
CreateClientConVar("cl_staff_smoke",1,true,false);
CreateClientConVar("cl_dexgun_dynlights",0,true,false);
CreateClientConVar("cl_dexgun_dynlights_flight",0,true,false);
CreateClientConVar("cl_shield_hitradius",1,true,false);
CreateClientConVar("cl_shield_hiteffect",1,true,false);
CreateClientConVar("cl_shield_dynlights",0,true,false);
CreateClientConVar("cl_shield_bubble",1,true,false);
CreateClientConVar("cl_drone_glow",1,true,false);
CreateClientConVar("cl_harvester_dynlights",1,true,false);
CreateClientConVar("cl_cloaking_shader",1,true,false);
CreateClientConVar("cl_cloaking_hitshader",1,true,false);

--################ Check for visuals (used in effects) @aVoN
function StarGate.Visuals(str)
	if(util.tobool(LocalPlayer():GetInfo("cl_stargate_visuals")) and util.tobool(LocalPlayer():GetInfo(str))) then
		return true;
	end
	return false;
end

--################ Reset values to 0, if this user just updated to this version @aVoN
-- The reason is, some dynamic lights crash players. So I want to have them disabled by default.
-- But sadly they already have the necessary CVAR set to 1. So I reset it to 0 once.
-- Now if they reset it to 1 it will keep of course at 1.
function StarGate.Hook.KeyPress(p,k)
	local check = util.tobool(file.Read("stargate.cvar.check.txt"));
	if(not check) then
		file.Write("stargate.cvar.check.txt","1");
		for _,v in pairs({"cl_staff_dynlights","cl_staff_dynlights_flight","cl_dexgun_dynlights","cl_dexgun_dynlights_flight","cl_shield_dynlights"}) do
			RunConsoleCommand(v,"0");
		end
	end
	hook.Remove("KeyPress","StarGate.Hook.KeyPress");
end
hook.Add("KeyPress","StarGate.Hook.KeyPress",StarGate.Hook.KeyPress);

--################# Adds the tab to the spawnmenu @aVoN
function StarGate.Hook.AddToolTab()
	-- I needed to remove this because in the upcoming update of GarrysMod, this hook is called to early and the usermessage won't have arrived yet.
	--if(StarGate.Installed) then
		-- Add Tab
		local logo;
		if(file.Exists("../materials/gui/stargate_logo.vmt")) then logo = "gui/stargate_logo" end;
		spawnmenu.AddToolTab("Stargate","Stargate",logo);
		-- Add Config Category
		spawnmenu.AddToolCategory("Stargate","Config"," Config");
		-- Add the entry for config
		spawnmenu.AddToolMenuOption("Stargate","Config","GraphicSettings"," Graphic Settings","","",StarGate.ConfigMenu,{SwitchConVar="cl_stargate_visuals"});
		-- Add the entry for Credits and Bugreporting!
		spawnmenu.AddToolMenuOption("Stargate","Config","Credits","Credits and Bugs","","",StarGate.Credits);
		-- Add our stargate tools to the tab
		local toolgun = weapons.Get("gmod_tool");
		if(toolgun and toolgun.Tool) then
			for k,v in pairs(toolgun.Tool) do
				if(not v.AddToMenu and v.Tab == "Stargate") then
					spawnmenu.AddToolMenuOption(
						v.Tab,
						v.Category or "",
						k,
						v.Name or "#"..k,
						v.Command or "gmod_tool "..k,
						v.ConfigName or k,
						v.BuildCPanel
					);
				end
			end
		end
	--end
end
hook.Add("AddToolMenuTabs","StarGate.Hook.AddToolTab",StarGate.Hook.AddToolTab);

--################ The config Menu @aVoN
function StarGate.ConfigMenu(Panel)
	local high = "Frame Burst: High";
	local medium = "Frame Burst: Medium";
	local low = "Frame Burst: Low";
	
	Panel:ClearControls();
	-- The HELP Button
	local VGUI = vgui.Create("SHelpButton",Panel);
	VGUI:SetHelp("config/visual");
	VGUI:SetTopic("Help:  Visual Settings");
	Panel:AddPanel(VGUI);
	-- Configuration
	Panel:CheckBox("Draw Effects","cl_stargate_visuals"):SetToolTip("Turning this off will disable all settings below. When it's on, the settings below will be used");
	-- Stargates
	Panel:Help("Stargate");
	Panel:CheckBox("Dynamic Lights","cl_stargate_dynlights"):SetToolTip(high);
	Panel:CheckBox("Draw ripple on the Eventhorizon","cl_stargate_ripple"):SetToolTip(medium);
	-- Staff Weapon
	Panel:Help("Staff Weapon");
	Panel:CheckBox("Dynamic Lights when hitting","cl_staff_dynlights"):SetToolTip(high);
	Panel:CheckBox("Dynamic Lights while flying","cl_staff_dynlights_flight"):SetToolTip(high);
	Panel:CheckBox("Smoke","cl_staff_smoke"):SetToolTip(medium);
	Panel:CheckBox("Scorch on Walls","cl_staff_scorch"):SetToolTip(low);
	-- Dexgun Weapon
	Panel:Help("Ronon's Gun");
	Panel:CheckBox("Dynamic Lights when hitting","cl_dexgun_dynlights"):SetToolTip(high);
	Panel:CheckBox("Dynamic Lights while flying","cl_dexgun_dynlights_flight"):SetToolTip(high);
	-- Zat'nik'tel
	Panel:Help("Zat'nik'tel");
	Panel:CheckBox("Dynamic Lights","cl_zat_dynlights"):SetToolTip(high);
	Panel:CheckBox("Hit Effect","cl_zat_hiteffect"):SetToolTip(medium);
	Panel:CheckBox("Dissolve Effect","cl_zat_dissolveeffect"):SetToolTip(medium);
	-- Shield
	Panel:Help("Shield");
	Panel:CheckBox("Dynamic Lights","cl_shield_dynlights"):SetToolTip(high);
	Panel:CheckBox("Shield Bubble","cl_shield_bubble"):SetToolTip(medium);
	Panel:CheckBox("Hit Refraction","cl_shield_hitradius"):SetToolTip(medium);
	Panel:CheckBox("Hit Effect","cl_shield_hiteffect"):SetToolTip(low);
	-- Drones
	Panel:Help("Drone");
	Panel:CheckBox("Glow","cl_drone_glow"):SetToolTip(low);
	-- Harvester
	Panel:Help("Wraith Harvester");
	Panel:CheckBox("Dynamic Lights","cl_harvester_dynlights"):SetToolTip(high);
	-- Cloaking
	Panel:Help("Cloaking");
	Panel:CheckBox("Draw Effect when passing Field","cl_cloaking_hitshader"):SetToolTip(high);
	Panel:CheckBox("Cloaking Effect","cl_cloaking_shader"):SetToolTip(medium);
end

--################ The credtis @aVoN
function StarGate.Credits(Panel)
	-- The Credits Button
	if(StarGate.HasInternet) then
		local VGUI = vgui.Create("SHelpButton",Panel);
		VGUI:SetHelp("credits");
		VGUI:SetTopic("Credits");
		VGUI:SetText("Credits");
		VGUI:SetImage("gui/silkicons/star");
		Panel:AddPanel(VGUI);
		Panel:Help("Here, you can report bugs. If you can't type in the HTML-Formulars, visit "..StarGate.HTTP.BUGS.." with your webbrowser");
		local VGUI = vgui.Create("SHelpButton",Panel);
		VGUI:SetTopic("Bugs");
		VGUI:SetText("Bugs");
		VGUI:SetImage("gui/silkicons/exclamation");
		VGUI:SetURL(StarGate.HTTP.BUGS);
		Panel:AddPanel(VGUI);
		Panel:Help("");
		if(StarGate.LATEST_VERSION and StarGate.LATEST_VERSION > StarGate.VERSION) then
			Panel:Help("Your Version of Stargate is out of date");
			Panel:Help("LATEST VERSION: "..StarGate.LATEST_VERSION);
		end
		Panel:Help("VERSION: "..StarGate.VERSION);
	else
		Panel:Help("It seems like, you are not connected to the Internet. Therefore, the Credits and Bugreport can't be shown");
	end
end
