/*
	Stargate SENT for GarrysMod10
	Copyright (C) 2007  aVoN

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

--################# HEADER #################
--################# Include
AddCSLuaFile("cl_init.lua");
AddCSLuaFile("shared.lua");
include("shared.lua");
include("modules/dialling.lua");
--################# Defines
-- Models
ENT.Models = {
	Base="models/zup/stargate/stargate_base.mdl",
	Ring="models/zup/stargate/stargate_gring.mdl",
	Chevron={
		"models/zup/stargate/stargate_chev1.mdl",
		"models/zup/stargate/stargate_chev2.mdl",
		"models/zup/stargate/stargate_chev3.mdl",
		"models/zup/stargate/stargate_chev4.mdl",
		"models/zup/stargate/stargate_chev5.mdl",
		"models/zup/stargate/stargate_chev6.mdl",
		"models/zup/stargate/stargate_chev7.mdl",
	}
}
-- Sounds
ENT.Sounds = {
	Ring=Sound("stargate/gate_roll.mp3"),
	Open=Sound("stargate/gate_open.mp3"),
	Travel=Sound("stargate/gate_travel.mp3"),
	Close=Sound("stargate/gate_close.mp3"),
	ChevronDHD=Sound("stargate/chevron_dhd.mp3"),
	Inbound=Sound("stargate/chevron_incoming.mp3");
	Lock=Sound("stargate/chevron_lock.mp3"),
	LockDHD=Sound("stargate/chevron_lock_dhd.mp3"),
	Chevron={Sound("stargate/chevron.mp3"),Sound("stargate/chevron2.mp3")},
	Fail=Sound("stargate/dial_fail.mp3"),
}
--################# SENT CODE ###############

--################# Init @aVoN
function ENT:Initialize()
	self.Entity:SetModel(self.Models.Base);
	self.Entity:PhysicsInit(SOLID_VPHYSICS);
	self.Entity:SetMoveType(MOVETYPE_VPHYSICS);
	self.Entity:SetSolid(SOLID_VPHYSICS);
	self.BaseClass.Initialize(self); -- BaseClass Initialize call
	self:AddRing();
	self:AddChevron();
end

--################# Either allow the player to spawn this or not
function ENT:SpawnFunction(p,t)
	if (not t.Hit) then return end
	local e = ents.Create("stargate_sg1");
	e:SetPos(t.HitPos+Vector(0,0,90));
	e:Spawn();
	e:Activate();
	--################# Set correct angle for the spawned prop
	local ang = p:GetAimVector():Angle(); ang.p = 0; ang.r = 0; ang.y = (ang.y+180) % 360
	e:SetAngles(ang);
	e:PutIntoRamps(t);
	return e;
end

--################# Creates the ring for the gate @aVoN
function ENT:AddRing()
	local pos = self.Entity:GetPos();
	local e = ents.Create("func_rotating");
	e:SetKeyValue("spawnflags",4); -- rotate around x-axis
	e:SetKeyValue("rendermode",10); -- dont draw,or the game crashes on touch
	e:SetKeyValue("maxspeed",30);
	e:SetModel(self.Models.Ring);  -- Dummy model, or the game crashes if you touch the func_rotating
	e:SetParent(self.Entity);
	e:SetPos(pos);
	e:Spawn();
	e:Activate();
	self.Ring = e;
	--Spawn the "real" ring (model)
	local e = ents.Create("prop_dynamic_override");
	e:SetModel(self.Models.Ring);
	e:SetKeyValue("solid",0);
	e:SetPos(pos);
	e:SetParent(self.Ring);
	e:SetDerive(self.Entity); -- Derive Material/Color from "Parent"
	e:DrawShadow(false);
	e:Spawn();
	e:Activate();
end

--################# Makes it rotate or stop @aVoN
function ENT:ActivateRing(b)
	if(not ValidEntity(self.Ring)) then return end;
	if(b) then
		self.Ring:Fire("Reverse","",0); -- Reverse direction first
		self.Ring:Fire("start","",0);
		self.Entity:EmitSound(self.Sounds.Ring,90,math.random(97,103));
	else
		self.Ring:Fire("stop","",0);
		self.Entity:StopSound(self.Sounds.Ring);
	end
end

--################# Adds all chevrons @aVoN
function ENT:AddChevron()
	self.Chevron={};
	local pos = self.Entity:GetPos();
	for i=1,7 do
		local e = ents.Create("prop_dynamic_override");
		e:SetModel(self.Models.Chevron[i]);
		e:SetParent(self.Entity);
		e:SetDerive(self.Entity); -- Derive Material/Color from "Parent"
		e:DrawShadow(false);
		e:SetPos(pos);
		e:Spawn();
		e:Activate();
		self.Chevron[i] = e;
		e:SetDerive(self.Entity); -- Derive Material/Color from "Parent"
	end
end

--################# Activates or deactivates a chevron @aVoN
function ENT:ActivateChevron(chev,b)
	if(not (self and self.Chevron)) then return end;
	if(self.Chevron[chev]) then
		if(b) then
			self.Chevron[chev]:Fire("skin",1);
			self.Entity:SetNWBool("chevron"..chev,true); -- Dynamic light of the chevron
		else
			self.Chevron[chev]:Fire("skin",0);
			self.Entity:SetNWBool("chevron"..chev,false); -- Dynamic light of the chevron
		end
	end
end

--################# Makes chevron 7 go up and down @aVoN
function ENT:Chevron7Animation(fast)
	-- Up and down animation
	local delay = 0.4;
	if(fast) then delay = 0 end;
	self.Chevron[7]:Fire("SetAnimation","chev7lock",delay);
end

--################# Chevron locking sound? @aVoN
function ENT:ChevronSound(chev,fast,inbound)
	local snd = self.Sounds.ChevronDHD; -- Fast dial with DHD
	-- Manual slowdial
	if(not fast) then
		snd = self.Sounds.Chevron[math.random(1,2)];
	end
	-- Inbound dial
	if(inbound) then
		snd = self.Sounds.Inbound;
	end
	if(chev == 7 and not inbound) then
		snd = self.Sounds.Lock;
		if(fast) then
			--	snd = self.Sounds.LockDHD; -- Seems like I haven used that in REALLY really earlier times. Not needed anymore!
		end
	end
	self.Entity:EmitSound(snd,90,math.random(97,104));
end

function ENT:Shutdown() end -- Not needed but added for example. It is called at the end of ENT:Close or ENT.Sequence:DialFail
