AddCSLuaFile( "cl_init.lua" )
AddCSLuaFile( "shared.lua" )
include('shared.lua')

ENT.HoleFix = {
	{"models/props_lab/bindergreen.mdl",Vector(-1,6.5,-17)},
	{"models/props_lab/binderblue.mdl",Vector(-1,6.5,-5)},
}

function ENT:Initialize()
	self.Entity:SetModel("models/mak/panel/panel.mdl")
	self.Entity:PhysicsInit( SOLID_VPHYSICS )
	self.Entity:SetMoveType(MOVETYPE_VPHYSICS)
	self.Entity:SetSolid(SOLID_VPHYSICS)

	self.Pair=self.Entity
	self.Entity:SetUseType(SIMPLE_USE)
end

function ENT:KeyValue(key,value)
	if key=="pair" then
		for k,v in pairs(ents.FindByName(value)) do
			self.Pair=v
		end
	end
end

function ENT:SpawnFunction( ply, tr)
	local SpawnPos = tr.HitPos + tr.HitNormal * 50
	local ang = ply:GetAimVector():Angle(); ang.p = 0; ang.r = 0; ang.y = (ang.y+180) % 360
	local ent = ents.Create( "ring_panel" )
	ent:SetPos( SpawnPos )
	ent:SetAngles(ang);
	ent:Spawn()
	ent:Activate()
	ent:DropToFloor();
	ent:PhysWake();
	return ent
end

function ENT:Use(ply)
	if self.Pair~=self.Entity and ValidEntity(self.Pair) then
		--self.Pair:Fire("teleport","",0)
		umsg.Start("RingTransporterShowWindow", ply)
		umsg.End()
		ply.RingDialEnt=self
		-- "Dial Button" Sound @aVoN
		self.Entity:EmitSound(Sound("tech/ring_button2.mp3"));
	end
end

function ENT:DoCallback(range,address)
	if self.Pair==self.Entity then return end -- well that was a bloody waste of time
	local ranger=50
	if range=="1" then
		ranger=1024
	end
	if not self.Pair.Busy then
		self.Pair.SetRange=tonumber(ranger)
		self.Pair:Dial(address)
	end
	-- success!
end

function RingsDiallingCallback(ply,cmd,args)
	if ply.RingDialEnt and ply.RingDialEnt~=NULL then
		if args[1] and not args[2] then
			ply.RingDialEnt:DoCallback(args[1],"")
		end
		if args[1] and args[2] then
			ply.RingDialEnt:DoCallback(args[1],args[2])
		end
		ply.RingDialEnt:EmitSound(Sound("tech/ring_button1.mp3")); -- "Dial Button" Sound @aVoN
		ply.RingDialEnt=nil
	end
end
concommand.Add("dodialrings",RingsDiallingCallback)

function ENT:Touch(ent)
	if self.Pair==self.Entity or not ValidEntity(self.Pair) then
		if ent:GetClass()=="ring_base" then
			self.Pair=ent
			self:SetEntityModifier("RingBase",ent)
			local ed = EffectData()
 				ed:SetEntity( self.Entity )
 			util.Effect( "propspawn", ed, true, true )
		end
	end
end

--##################################
--#### Duplicator Entity Modifiers (for the ringpanel)
--##################################

--################# Sets a new value to one modifier @aVoN
function ENT:SetEntityModifier(k,v)
	self.Duplicator = self.Duplicator or {};
	self.Duplicator[k] = v;
	duplicator.StoreEntityModifier(self.Entity,"RingPanel",self.Duplicator);
end

-- FIXME: Maybe a recode? The PostEntityPaste etc functions are already used by Wire/RD2 so I do not want to override them.
function ENT.DuplicatorEntityModifier(_,e,data)
	if(data) then
		for k,v in pairs(data) do
			if(k == "RingBase" and ValidEntity(v)) then
				e.Pair = v;
			end
			e:SetEntityModifier(k,v);
		end
	end
end
duplicator.RegisterEntityModifier("RingPanel",ENT.DuplicatorEntityModifier);