include('shared.lua')

function ENT:Initialize()
	self.DAmt=0
	self.RAmt=255
end

function ENT:Draw()
	if ( LocalPlayer():GetEyeTrace().Entity == self.Entity && EyePos():Distance( self.Entity:GetPos() ) < 512 ) then
		self.DAmt=math.Clamp(self.DAmt+0.1,0,1)
		self.RAmt=math.Clamp(self.RAmt+50,0,255)
	else
		self.DAmt=math.Clamp(self.DAmt-0.05,0,1)
		self.RAmt=math.Clamp(self.RAmt-5,50,255)
	end
	self.Entity:SetColor(255,255,255,self.RAmt)
	self.Entity:DrawModel()
		local ang=self.Entity:GetAngles()
		ang:RotateAroundAxis(ang:Right(),	90)
		ang:RotateAroundAxis(ang:Up(),		-90)
		
		local str=self.Entity:GetNetworkedString("address","USE to set address")
		surface.SetFont("SandboxLabel")
		local w,h=surface.GetTextSize(str)
		
		cam.Start3D2D(self.Entity:GetPos()+(self.Entity:GetUp()*10), ang, 0.05 )
			surface.SetDrawColor( 128, 128, 128, 200*self.DAmt )
			surface.DrawRect(0-w/2, 0, w, h)
			draw.DrawText(str, "SandboxLabel", 0, 0, Color(255,255,255,255*self.DAmt), TEXT_ALIGN_CENTER )
		cam.End3D2D()
		
		ang:RotateAroundAxis(ang:Right(),	180)
		cam.Start3D2D(self.Entity:GetPos()+(self.Entity:GetUp()*10), ang, 0.05 )
			surface.SetDrawColor( 128, 128, 128, 128*self.DAmt )
			surface.DrawRect(0-w/2, 0, w, h)
			draw.DrawText(str, "SandboxLabel", 0, 0, Color(255,255,255,255*self.DAmt), TEXT_ALIGN_CENTER )
		cam.End3D2D()
end

local PANEL = {}

function PANEL:DoClick()
	local panel2=self:GetParent()
	LocalPlayer():ConCommand("doringname "..panel2.TextEntry:GetValue())
	panel2:Remove()
end

vgui.Register( "RingNameButton", PANEL, "Button" )

local PANEL = {}
function PANEL:Init()
	self:SetSize(400,500)
	self:SetName( "Name" )
 	self.TextEntry = vgui.Create( "TextEntry", self )
 	self.TextEntry:SetText("")

 	self.L1 = vgui.Create( "Label", self )
 	self.L1:SetText("Name this base:")

 	self.Button = vgui.Create( "RingNameButton", self)
	self.Button:SetText("OK")
end

function PANEL:Paint()
	draw.RoundedBox( 10, 0, 0, self:GetWide(), self:GetTall() , Color(16,16,16,160) )
	return true
end
   
function PANEL:PerformLayout()

 	self:SetSize( 700, 150 )

	self.Button:SetPos(10,90)

 	self.TextEntry:SetSize( 400, self.TextEntry:GetTall() )
 	self.TextEntry:SetPos( 10, 40 )

 	self.L1:SetPos( 10, 15 )
 	self.L1:SetSize( 700, 30 )
end

vgui.Register( "RingNameEntry", PANEL, "Frame" )

function RingTransporterShowNameWindow(um)
	local Window = vgui.Create( "RingNameEntry" )
	Window:SetKeyBoardInputEnabled( true )
	Window:SetMouseInputEnabled( true )
	Window:SetPos( (ScrW()/2 - 350) / 2, ScrH()/2 - 75 )
	Window:SetVisible( true )
	local e = um:ReadEntity();
	if(not ValidEntity(e)) then return end;
	Window.TextEntry:SetText(e:GetNWString("address"));
end
usermessage.Hook("RingTransporterShowNameWindow", RingTransporterShowNameWindow)

-- Old method I don't like
--[[
local efa=0
local eff=1
local ef=-1
function RingTransporterCalcView(ply,origin,angles,fov)
	if ef==-1 then return end
	if ef==0 then
		eff=math.Clamp(eff+0.1,1,1.5)
	end
	if ef==1 then
		eff=math.Clamp(eff-0.01,1,1.5)
		if eff==1 then ef=-1 return end
	end
	local view={}
	view.origin=origin
	view.angles=angles
	view.fov=fov*eff	
	return view
end
hook.Add("CalcView", "RingTransporterCalcView", RingTransporterCalcView) 

function RingTransporterHUDPaint()
	if ef==-1 then return end
	if ef==0 then
		efa=math.Clamp(efa+100,0,255)
	end
	if ef==1 then
		efa=math.Clamp(efa-20,0,255)
	end
	surface.SetDrawColor(255,255,255,efa)
	surface.DrawRect(0,0,ScrW(),ScrH())
end
hook.Add("HUDPaint","RingTransporterHUDPaint",RingTransporterHUDPaint)
function RingTransporterTele(um)
	local stat=um:ReadBool()
	if stat==true then
		ef=0
		timer.Create("RingTeleSafeTimer", 10, 1, function() ef=1 end)
	else
		ef=1
	end
end
usermessage.Hook("RingTransporterTele", RingTransporterTele)
--]]

local start;
local alpha = 0;
local go;
hook.Add("HUDPaint","RingTransporterHUDPaint",
	function()
		if(not start) then return end;
		local rate = 2000;
		local offset = 0;
		if(not go) then
			rate = -1000;
			offset = 255;
		end
		alpha = math.Clamp(offset + (CurTime() - start)*rate,0,255);
		surface.SetDrawColor(255,255,255,alpha);
		surface.DrawRect(0,0,ScrW(),ScrH());
		if(alpha == 0) then start = nil end;
	end
);

usermessage.Hook("RingTransporterTele",
	function (data)
		go = data:ReadBool()
		start = CurTime();
		if(go) then timer.Create("RingTeleSafeTimer",5,1,function() start = nil end) end;
	end
);