/*
	Stargate Lib for GarrysMod10
	Copyright (C) 2007  aVoN

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
StarGate.Installed = true;
--#########################################
--						Config System
--#########################################

--################# Loads the config @aVoN
function StarGate.LoadConfig(p)
	if(not p or p:IsAdmin()) then
		StarGate.CFG.SYNC = {}; -- They sync keys
		-- Loads the config only ONE time and not always when I press "sent_reload" (Increases loading times)
		if(not INIParser) then include("ini_parser.lua") end;
		local ini = INIParser:new("stargate/config.ini");
		local custom_config = INIParser:new("stargate/user_config.ini");
		-- Merge our custom config with the default one
		if(custom_config) then
			for node,datas in pairs(custom_config.nodes) do
				ini.nodes[node] = ini.nodes[node] or {};
				for num,data in pairs(datas) do
					ini.nodes[node][num] = ini.nodes[node][num] or {};
					for k,v in pairs(data) do
						ini.nodes[node][num][k] = v;
					end
				end
			end
		end
		for name,cfg in pairs(ini:get()) do
			if(name ~= "config") then
				StarGate.CFG[name] = {};
				local sync = (cfg[1].SYNC or ""):TrimExplode(",");
				for k,v in pairs(cfg[1]) do
					v=v:Trim();
					local number = tonumber(v);
					if(number) then 
						v = number;
					elseif(v == "false" or v == "true") then
						v = util.tobool(v);
					end
					StarGate.CFG[name][k] = v;
					-- Sync the values with the Client
					if(table.HasValue(sync,k)) then
						StarGate.CFG.SYNC[name] = StarGate.CFG.SYNC[name] or {};
						StarGate.CFG.SYNC[name][k] = v;
					end
				end
			end
		end
	end
end
StarGate.LoadConfig();
concommand.Add("stargate_reloadconfig",StarGate.LoadConfig);

--################# Starts syncing the CFG from the server to the client @aVoN
function StarGate.Hook.PlayerInitialSpawn(p)
	-- Most important thing first: Tell the client, StargatePack is installed!
	if(p and p:IsValid() and p:IsPlayer()) then
		umsg.Start("StarGate_IsOnServer",p);
		umsg.End();
	end
	-- Now start syncing the config (also tells the client, SGPack is installed - just to be sure)
	for name,data in pairs(StarGate.CFG.SYNC) do
		if(p and p:IsValid() and p:IsPlayer()) then -- Prevents crashing (must be done everytime we send a umsg!)
			umsg.Start("StarGate_CFG",p);
			umsg.String(name); -- Tell the client, what CFG node
			umsg.Char(table.Count(data)); -- Tell the client, how much data will follow (Char goes from -128 to 128). But you seriously shoudln't add more than 20 umsg!
			for k,v in pairs(data) do
				umsg.String(k); -- Tell the client, what's the keys name
				if(type(v) == "boolean") then
					umsg.Char(0); -- I'm a bool
					umsg.Bool(v);
				elseif(type(v) == "string") then
					umsg.Char(1); -- I'm a string
					umsg.String(v);
				else -- I'm a sort of number
					if(v ~= math.ceil(v)) then -- I'm a float
						umsg.Char(2);
						umsg.Float(v);
					elseif(v > -128 and v < 127) then -- I'm a Char
						umsg.Char(3);
						umsg.Char(v);
					elseif(v > -32768 and v < 32767) then -- I'm a short
						umsg.Char(4);
						umsg.Short(v);
					else -- I'm a long
						umsg.Char(5);
						umsg.Long(v);
					end
				end
			end
			umsg.End();
		end
	end
end
hook.Add("PlayerInitialSpawn","StarGate.Hook.PlayerInitialSpawn",StarGate.Hook.PlayerInitialSpawn);