/*
	ZPM for GarrysMod10, based on Shanjaq's Energy Cell,modified by Anorr and aVoN
	Copyright (C) 2007 JDM12989

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
--################# HEADER #################
AddCSLuaFile("cl_init.lua");
AddCSLuaFile("shared.lua");
include("shared.lua");
--################# SENT CODE ###############

--################# Init @JDM12989
function ENT:Initialize()
	self.Entity:SetModel("models/zup/zpm/zpm.mdl");
	self.Entity:SetMaterial("zup/zpm/zpm.vmt");
	self.Entity:PhysicsInit(SOLID_VPHYSICS);
	self.Entity:SetMoveType(MOVETYPE_VPHYSICS);
	self.Entity:SetSolid(SOLID_VPHYSICS);
	self.MaxEnergy = StarGate.CFG:Get("zpm","capacity",10000000);
	self.enabled = false;
	self:AddResource("ZPE",self.MaxEnergy); --ZeroPoint energy @Anorr
	self:SupplyResource("ZPE",self.MaxEnergy);
	self:AddResource("energy",StarGate.CFG:Get("zpm","energy_capacity",5000)); -- Maximum energy to store in a ZPM is 5000 units
	self:CreateWireOutputs("Active","Energy","ZPM %","Zero Point Energy");
	local phys = self.Entity:GetPhysicsObject();
	if(phys:IsValid()) then
		phys:Wake();
		phys:SetMass(10);
	end
end

--################# Spawn the SENT @JDM12989
function ENT:SpawnFunction(p,t)
	if(not t.Hit) then return end;
	local e = ents.Create("Zero_Point_Module");
	e:SetPos(t.HitPos+Vector(0,0,10));
	e:Spawn();
	return e;
end

--################# Adds the annoying overlay speechbubble to this SENT @JDM12989
function ENT:ShowOutput(v,force)
	local add = "(Off)";
	if(self.enabled) then add = "(On)" end;
	self:SetOverlayText("Zero Point Module "..add.."\n"..v.."%");
end

--################# Think @JDM12989
function ENT:Think()
	if(self.depleted or not self.HasResourceDistribution) then return end;
	local energy = self:GetResource("energy");
	local ZPE = self:GetResource("ZPE");
	local my_capacity = self:GetUnitCapacity("energy");
	local nw_capacity = self:GetNetworkCapacity("energy");
	local percent = (ZPE/self.MaxEnergy)*100;
	if(my_capacity ~= nw_capacity) then -- We are connected to a network - Enable ZPM
		if(not self.enabled) then
			self.Entity:SetMaterial("Zup/ZPM/zpm_on.vmt");
			self.enabled = true;
		end
	else
		if(self.enabled) then
			self.Entity:SetMaterial("Zup/ZPM/zpm.vmt");
			self.enabled = false;
		end
	end
	-- No ZeroPointEnergy available anymore - We are depleted!
	if(ZPE == 0) then
		self.Entity:SetMaterial("Zup/ZPM/zpm_depleted.vmt");
		self.depleted = true;
		self.enabled = false;
		self:SetOverlayText("Zero Point Module\nDepleted");
	end
	-- Energy conversion when availeble storage @Anorr,aVoN
	if(self.enabled and energy < nw_capacity) then
		local rate = (my_capacity+nw_capacity)/2; -- Two passes until it filled the full network
		rate = math.Clamp(rate,0,ZPE);
		rate = math.Clamp(rate,0,nw_capacity-energy);
		self:SupplyResource("energy",rate);
		self:ConsumeResource("ZPE",rate);
	end
	if(self.depleted and Dev_Unlink_All) then
		Dev_Unlink_All(self.Entity);
		self:SetWire("Active",-1);
	else
		self:ShowOutput(percent);
		self:SetWire("Active",self.enabled);
		self:SetWire("Energy",math.floor(energy));
		self:SetWire("Zero Point Energy",math.floor(ZPE));
		self:SetWire("ZPM %",percent);
	end
	self.Entity:NextThink(CurTime()+0.5);
	return true;
end
