#include <windows.h>
#include <iostream>
#include <fstream>
#include <string>

#define MAX_WNDS 10

void closeWnd(LPCSTR wndName)
{
	using namespace std;
    
	HWND handle = FindWindow(0,wndName);
    if ( handle )
    {
		cout << endl;
		cout << "Window '" << wndName << "' found!" << endl;

		HWND button = FindWindowEx(handle,0,0,"OK");
		if ( button )
		{
			SendMessage(button,BM_CLICK,0,0);
			cout << "Button clicked." << endl;
		} else {
			cout << "ERROR: Button not found." << endl;
		}

		cout << endl;
    }
}

int main()
{
	using namespace std;
	
	cout << "Error Message Handler" << endl << endl;
	
	ifstream inf("windownames.txt");
	if ( !inf )
	{
		cerr << "ERROR: windownames.txt could not be opened for reading!" << endl;
		Sleep(5000);
		return EXIT_FAILURE;
	}

	string wndNames[MAX_WNDS];
	string line;
	int cnt = 0;

	while (getline(inf, line))
	{
		if ( line.empty() )
			continue;

		wndNames[cnt] = line;
		cout << "Error window " << cnt << " loaded: " << line << endl;
		cnt++;

		if ( cnt >= MAX_WNDS )
			break;
	}

	cout << endl;
	cout << "Entering idle mode..." << endl;
	
	while ( 1 )
	{
		for ( int i = 0; i < cnt; i++ )
		{
			closeWnd(wndNames[i].c_str());
		}
		Sleep(5000);
	}

	return 0;
}

