
   
 /*--------------------------------------------------------- 
    Initializes the effect. The data is a table of data  
    which was passed from the server. 
 ---------------------------------------------------------*/ 
 function EFFECT:Init( data ) 
	
 	
 	self.vOffset = data:GetOrigin()
	local dir = data:GetNormal()
	local emitter = ParticleEmitter( self.vOffset )
		for i=0, (8) do
			local particle = emitter:Add( "particles/flamelet"..math.random(1,5), self.vOffset + (dir * 30 * i))
			if (particle) then
				particle:SetVelocity((dir * 60 * i) )
				particle:SetLifeTime( 0 )
				particle:SetDieTime( 0.2 )
				particle:SetStartAlpha( math.Rand( 200, 255 ) )
				particle:SetEndAlpha( 0 )
				particle:SetStartSize( 50 - 5 * i )
				particle:SetEndSize( 0 )
				particle:SetRoll( math.Rand(0, 360) )
				particle:SetRollDelta( math.Rand(-40, 40) )
				particle:SetColor( 255 , 255 , 255 )
			end
		end
		
		for i=0, 2 do
		
			local Pos = Vector( math.Rand(-1,1), math.Rand(-1,1), math.Rand(-1,1) ):GetNormalized() 
		
			local particle = emitter:Add( "particles/smokey", self.vOffset + dir * math.Rand(10, 40 ))
			if (particle) then
				particle:SetVelocity(VectorRand() * 20 + dir * math.Rand(60,100))
				particle:SetLifeTime( 0 )
				particle:SetDieTime( math.Rand( 1, 3 ) )
				particle:SetStartAlpha( math.Rand( 200, 255 ) )
				particle:SetEndAlpha( 0 )
				particle:SetStartSize( 30 )
				particle:SetEndSize( 40 )
				particle:SetRoll( math.Rand(0, 360) )
				particle:SetRollDelta( math.Rand(-0.2, 0.2) )
				
				particle:SetAirResistance( 70 ) 
 				 
 				particle:SetGravity( Vector( 0, 0, 4 ) ) 
				
				particle:SetColor( 255 , 255 , 255 )
			end
			
		end
	emitter:Finish() 
 end 
   
   
/*---------------------------------------------------------
   THINK
---------------------------------------------------------*/
function EFFECT:Think( )
	return false
end

/*---------------------------------------------------------
   Draw the effect
---------------------------------------------------------*/
function EFFECT:Render()
end

 