
local SKIN = {}

// These are used in the settings panel

SKIN.PrintName 		= "Blue Skin"
SKIN.Author 		= "Florian 'Mitsuma' "
SKIN.DermaVersion	= 1

SKIN.colOutline	= Color( 0, 0, 0, 20 )

// You can change the colours from the Default skin

SKIN.colPropertySheet 			= Color( 75, 176, 243, 255 )
SKIN.colTab			 			= SKIN.colPropertySheet
SKIN.colTabText		 			= Color( 13, 121, 193, 200 )
SKIN.colTabInactive				= Color( 11, 100, 159, 155 )
SKIN.colTabShadow				= Color( 12, 114, 182, 255 )
SKIN.fontButton					= "Default"
SKIN.fontTab					= "Default"
SKIN.bg_color 					= Color( 18, 149, 240, 255 )
SKIN.bg_color_sleep 			= Color( 12, 119, 190, 255 )
SKIN.bg_color_dark				= Color( 12, 108, 173, 255 )
SKIN.bg_color_bright			= Color( 46, 163, 241, 255 )
SKIN.listview_hover				= Color( 85, 181, 244, 255 )
SKIN.listview_selected			= Color( 37, 159, 241, 255 )
SKIN.control_color 				= Color( 13, 128, 204, 255 )
SKIN.control_color_highlight	= Color( 15, 143, 230, 255 )
SKIN.control_color_active 		= Color( 30, 156, 240, 255 )
SKIN.control_color_bright 		= Color( 96, 185, 244, 255 )
SKIN.control_color_dark 		= Color( 13, 126, 202, 255 )
SKIN.text_bright				= Color( 159, 159, 159, 255 )
SKIN.text_normal				= Color( 145, 145, 145, 255 )
SKIN.text_dark					= Color( 15, 15, 15, 255 )
SKIN.text_highlight				= Color( 0, 0, 0, 20 )
SKIN.colCategoryText			= Color( 255, 255, 255, 255 )
SKIN.colCategoryTextInactive	= Color( 200, 200, 200, 255 )
SKIN.fontCategoryHeader			= "TabLarge"
SKIN.colTextEntryTextHighlight	= Color( 36, 146, 255, 255 )
SKIN.colCategoryText			= Color( 255, 255, 255, 255 )
SKIN.colCategoryTextInactive	= Color( 200, 200, 200, 255 )
SKIN.fontCategoryHeader			= "TabLarge"
SKIN.panel_transback			= Color( 109, 191, 245, 50 )
SKIN.tooltip					= Color( 73, 175, 243, 255 )

// Or any of the functions

function SKIN:DrawSquaredBox( x, y, w, h, color )

	surface.SetDrawColor( color )
	surface.DrawRect( x, y, w, h )
	
	surface.SetDrawColor( self.colOutline )
	surface.DrawOutlinedRect( x, y, w, h )

end

function SKIN:PaintFrame( panel )

	local color = self.bg_color

	self:DrawSquaredBox( 0, 0, panel:GetWide(), panel:GetTall(), color )
	
	surface.SetDrawColor( 0, 0, 0, 75 )
	surface.DrawRect( 0, 0, panel:GetWide(), 21 )
	
	surface.SetDrawColor( self.colOutline )
	surface.DrawRect( 0, 21, panel:GetWide(), 1 )

end

// Or just start a new skin from scratch by overriding the whole thing


//
// You need to add this to the bottom of your skin to register it in Derma.
// Parameters are name (which should have no spaces or special chacters), description, then the SKIN table
//

derma.DefineSkin( "blue_skin", "mitsuma's_blue_skin", SKIN )