
local SKIN = {}

// These are used in the settings panel

SKIN.PrintName 		= "Green Skin"
SKIN.Author 		= "Florian 'Mitsuma' "
SKIN.DermaVersion	= 1

SKIN.colOutline	= Color( 0, 0, 0, 20 )

// You can change the colours from the Default skin

SKIN.colPropertySheet 			= Color( 124, 252, 0, 255 )
SKIN.colTab			 			= SKIN.colPropertySheet
SKIN.colTabText		 			= Color( 19, 102, 17, 200 )
SKIN.colTabInactive				= Color( 17, 255, 4, 155 )
SKIN.colTabShadow				= Color( 19, 102, 17, 255 )
SKIN.fontButton					= "Default"
SKIN.fontTab					= "Default"
SKIN.bg_color 					= Color( 70, 185, 57, 255 )
SKIN.bg_color_sleep 			= Color( 64, 152, 54, 255 )
SKIN.bg_color_dark				= Color( 53, 125, 45, 255 )
SKIN.bg_color_bright			= Color( 79, 213, 99, 255 )
SKIN.listview_hover				= Color( 18, 109, 22, 255 )
SKIN.listview_selected			= Color( 18, 146, 12, 210 )
SKIN.control_color 				= Color( 55, 160, 44, 255 )
SKIN.control_color_highlight	= Color( 90, 220, 67, 255 )
SKIN.control_color_active 		= Color( 97, 220, 90, 255 )
SKIN.control_color_bright 		= Color( 146, 248, 143, 255 )
SKIN.control_color_dark 		= Color( 12, 132, 9, 255 )
SKIN.text_bright				= Color( 159, 159, 159, 255 )
SKIN.text_normal				= Color( 145, 145, 145, 255 )
SKIN.text_dark					= Color( 15, 15, 15, 255 )
SKIN.text_highlight				= Color( 0, 0, 0, 20 )
SKIN.colCategoryText			= Color( 255, 255, 255, 255 )
SKIN.colCategoryTextInactive	= Color( 200, 200, 200, 255 )
SKIN.fontCategoryHeader			= "TabLarge"
SKIN.colTextEntryTextHighlight	= Color( 0, 100, 2, 255 )
SKIN.colTextEntryTextHighlight	= Color( 0, 100, 2, 255 )
SKIN.colCategoryText			= Color( 255, 255, 255, 255 )
SKIN.colCategoryTextInactive	= Color( 200, 200, 200, 255 )
SKIN.fontCategoryHeader			= "TabLarge"
SKIN.panel_transback			= Color( 37, 210, 6, 50 )
SKIN.tooltip					= Color( 7, 151, 0, 255 )
SKIN.colTextEntryTextHighlight	= Color( 18, 109, 22, 255 )
SKIN.colTextEntryTextHighlight	= Color( 18, 109, 22, 255 )

// Or any of the functions

function SKIN:DrawSquaredBox( x, y, w, h, color )

	surface.SetDrawColor( color )
	surface.DrawRect( x, y, w, h )
	
	surface.SetDrawColor( self.colOutline )
	surface.DrawOutlinedRect( x, y, w, h )

end

function SKIN:PaintFrame( panel )

	local color = self.bg_color

	self:DrawSquaredBox( 0, 0, panel:GetWide(), panel:GetTall(), color )
	
	surface.SetDrawColor( 0, 0, 0, 75 )
	surface.DrawRect( 0, 0, panel:GetWide(), 21 )
	
	surface.SetDrawColor( self.colOutline )
	surface.DrawRect( 0, 21, panel:GetWide(), 1 )

end

// Or just start a new skin from scratch by overriding the whole thing


//
// You need to add this to the bottom of your skin to register it in Derma.
// Parameters are name (which should have no spaces or special chacters), description, then the SKIN table
//

derma.DefineSkin( "green_skin", "mitsuma's_green_skin", SKIN )